package zio.aws.proton.model
import zio.aws.proton.model.primitives.{Arn, EnvironmentAccountConnectionId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentAccountConnectionRequest(
    id: EnvironmentAccountConnectionId,
    roleArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest = {
    import UpdateEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
      .builder()
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest =
      zio.aws.proton.model
        .UpdateEnvironmentAccountConnectionRequest(id, roleArn)
    def id: EnvironmentAccountConnectionId
    def roleArn: Arn
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly {
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
    override val roleArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
