package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class ResourceSyncEvent(
    event: String,
    externalId: Optional[String] = Optional.Absent,
    time: Timestamp,
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ResourceSyncEvent = {
    import ResourceSyncEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ResourceSyncEvent
      .builder()
      .event(event: java.lang.String)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .time(Timestamp.unwrap(time): Instant)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ResourceSyncEvent.ReadOnly =
    zio.aws.proton.model.ResourceSyncEvent.wrap(buildAwsValue())
}
object ResourceSyncEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ResourceSyncEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ResourceSyncEvent =
      zio.aws.proton.model.ResourceSyncEvent(
        event,
        externalId.map(value => value),
        time,
        `type`
      )
    def event: String
    def externalId: Optional[String]
    def time: Timestamp
    def `type`: String
    def getEvent: ZIO[Any, Nothing, String] = ZIO.succeed(event)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(time)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ResourceSyncEvent
  ) extends zio.aws.proton.model.ResourceSyncEvent.ReadOnly {
    override val event: String = impl.event(): String
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
    override val time: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.time())
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ResourceSyncEvent
  ): zio.aws.proton.model.ResourceSyncEvent.ReadOnly = new Wrapper(impl)
}
