package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, GitBranchName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRepositorySyncStatusRequest(
    branch: GitBranchName,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    syncType: zio.aws.proton.model.SyncType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest = {
    import GetRepositorySyncStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .syncType(syncType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetRepositorySyncStatusRequest.ReadOnly =
    zio.aws.proton.model.GetRepositorySyncStatusRequest.wrap(buildAwsValue())
}
object GetRepositorySyncStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetRepositorySyncStatusRequest =
      zio.aws.proton.model.GetRepositorySyncStatusRequest(
        branch,
        repositoryName,
        repositoryProvider,
        syncType
      )
    def branch: GitBranchName
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def syncType: zio.aws.proton.model.SyncType
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getSyncType: ZIO[Any, Nothing, zio.aws.proton.model.SyncType] =
      ZIO.succeed(syncType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest
  ) extends zio.aws.proton.model.GetRepositorySyncStatusRequest.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val syncType: zio.aws.proton.model.SyncType =
      zio.aws.proton.model.SyncType.wrap(impl.syncType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest
  ): zio.aws.proton.model.GetRepositorySyncStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
