package zio.aws.proton.model
import zio.aws.proton.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRepositoryRequest(
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetRepositoryRequest = {
    import GetRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetRepositoryRequest
      .builder()
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetRepositoryRequest.ReadOnly =
    zio.aws.proton.model.GetRepositoryRequest.wrap(buildAwsValue())
}
object GetRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetRepositoryRequest =
      zio.aws.proton.model.GetRepositoryRequest(name, provider)
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetRepositoryRequest
  ) extends zio.aws.proton.model.GetRepositoryRequest.ReadOnly {
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetRepositoryRequest
  ): zio.aws.proton.model.GetRepositoryRequest.ReadOnly = new Wrapper(impl)
}
