package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountSettingsResponse(
    accountSettings: Optional[zio.aws.proton.model.AccountSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountSettings.map(value => value.buildAwsValue()))(
        _.accountSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.proton.model.GetAccountSettingsResponse.wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetAccountSettingsResponse =
      zio.aws.proton.model.GetAccountSettingsResponse(
        accountSettings.map(value => value.asEditable)
      )
    def accountSettings: Optional[zio.aws.proton.model.AccountSettings.ReadOnly]
    def getAccountSettings
        : ZIO[Any, AwsError, zio.aws.proton.model.AccountSettings.ReadOnly] =
      AwsError.unwrapOptionField("accountSettings", accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse
  ) extends zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : Optional[zio.aws.proton.model.AccountSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountSettings())
        .map(value => zio.aws.proton.model.AccountSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse
  ): zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
