package zio.aws.proton.model
import zio.aws.proton.model.primitives.GitBranchName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RepositorySyncDefinition(
    branch: GitBranchName,
    directory: String,
    parent: String,
    target: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositorySyncDefinition = {
    import RepositorySyncDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositorySyncDefinition
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .directory(directory: java.lang.String)
      .parent(parent: java.lang.String)
      .target(target: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositorySyncDefinition.ReadOnly =
    zio.aws.proton.model.RepositorySyncDefinition.wrap(buildAwsValue())
}
object RepositorySyncDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositorySyncDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositorySyncDefinition =
      zio.aws.proton.model.RepositorySyncDefinition(
        branch,
        directory,
        parent,
        target
      )
    def branch: GitBranchName
    def directory: String
    def parent: String
    def target: String
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getDirectory: ZIO[Any, Nothing, String] = ZIO.succeed(directory)
    def getParent: ZIO[Any, Nothing, String] = ZIO.succeed(parent)
    def getTarget: ZIO[Any, Nothing, String] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncDefinition
  ) extends zio.aws.proton.model.RepositorySyncDefinition.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val directory: String = impl.directory(): String
    override val parent: String = impl.parent(): String
    override val target: String = impl.target(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncDefinition
  ): zio.aws.proton.model.RepositorySyncDefinition.ReadOnly = new Wrapper(impl)
}
