package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsResponse(
    environments: Iterable[zio.aws.proton.model.EnvironmentSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse
      .builder()
      .environments(environments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.proton.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListEnvironmentsResponse =
      zio.aws.proton.model.ListEnvironmentsResponse(
        environments.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def environments: List[zio.aws.proton.model.EnvironmentSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEnvironments: ZIO[Any, Nothing, List[
      zio.aws.proton.model.EnvironmentSummary.ReadOnly
    ]] = ZIO.succeed(environments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse
  ) extends zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly {
    override val environments
        : List[zio.aws.proton.model.EnvironmentSummary.ReadOnly] = impl
      .environments()
      .asScala
      .map { item =>
        zio.aws.proton.model.EnvironmentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse
  ): zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(impl)
}
