package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelServiceInstanceDeploymentResponse(
    serviceInstance: zio.aws.proton.model.ServiceInstance
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse = {
    import CancelServiceInstanceDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse
      .builder()
      .serviceInstance(serviceInstance.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly =
    zio.aws.proton.model.CancelServiceInstanceDeploymentResponse
      .wrap(buildAwsValue())
}
object CancelServiceInstanceDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CancelServiceInstanceDeploymentResponse =
      zio.aws.proton.model
        .CancelServiceInstanceDeploymentResponse(serviceInstance.asEditable)
    def serviceInstance: zio.aws.proton.model.ServiceInstance.ReadOnly
    def getServiceInstance
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceInstance.ReadOnly] =
      ZIO.succeed(serviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse
  ) extends zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly {
    override val serviceInstance
        : zio.aws.proton.model.ServiceInstance.ReadOnly =
      zio.aws.proton.model.ServiceInstance.wrap(impl.serviceInstance())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse
  ): zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly =
    new Wrapper(impl)
}
