package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  Arn,
  DisplayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServiceTemplateRequest(
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    encryptionKey: Optional[Arn] = Optional.Absent,
    name: ResourceName,
    pipelineProvisioning: Optional[zio.aws.proton.model.Provisioning] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest = {
    import CreateServiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(pipelineProvisioning.map(value => value.unwrap))(
        _.pipelineProvisioning
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceTemplateRequest.ReadOnly =
    zio.aws.proton.model.CreateServiceTemplateRequest.wrap(buildAwsValue())
}
object CreateServiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceTemplateRequest =
      zio.aws.proton.model.CreateServiceTemplateRequest(
        description.map(value => value),
        displayName.map(value => value),
        encryptionKey.map(value => value),
        name,
        pipelineProvisioning.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def encryptionKey: Optional[Arn]
    def name: ResourceName
    def pipelineProvisioning: Optional[zio.aws.proton.model.Provisioning]
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getPipelineProvisioning
        : ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("pipelineProvisioning", pipelineProvisioning)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest
  ) extends zio.aws.proton.model.CreateServiceTemplateRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val encryptionKey: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val pipelineProvisioning
        : Optional[zio.aws.proton.model.Provisioning] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineProvisioning())
      .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest
  ): zio.aws.proton.model.CreateServiceTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
