package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ProvisionedResourceName,
  ProvisionedResourceIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionedResource(
    identifier: Optional[ProvisionedResourceIdentifier] = Optional.Absent,
    name: Optional[ProvisionedResourceName] = Optional.Absent,
    provisioningEngine: Optional[
      zio.aws.proton.model.ProvisionedResourceEngine
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ProvisionedResource = {
    import ProvisionedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ProvisionedResource
      .builder()
      .optionallyWith(
        identifier.map(value =>
          ProvisionedResourceIdentifier.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(
        name.map(value =>
          ProvisionedResourceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(provisioningEngine.map(value => value.unwrap))(
        _.provisioningEngine
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ProvisionedResource.ReadOnly =
    zio.aws.proton.model.ProvisionedResource.wrap(buildAwsValue())
}
object ProvisionedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ProvisionedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ProvisionedResource =
      zio.aws.proton.model.ProvisionedResource(
        identifier.map(value => value),
        name.map(value => value),
        provisioningEngine.map(value => value)
      )
    def identifier: Optional[ProvisionedResourceIdentifier]
    def name: Optional[ProvisionedResourceName]
    def provisioningEngine
        : Optional[zio.aws.proton.model.ProvisionedResourceEngine]
    def getIdentifier: ZIO[Any, AwsError, ProvisionedResourceIdentifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getName: ZIO[Any, AwsError, ProvisionedResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getProvisioningEngine
        : ZIO[Any, AwsError, zio.aws.proton.model.ProvisionedResourceEngine] =
      AwsError.unwrapOptionField("provisioningEngine", provisioningEngine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ProvisionedResource
  ) extends zio.aws.proton.model.ProvisionedResource.ReadOnly {
    override val identifier: Optional[ProvisionedResourceIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifier())
        .map(value =>
          zio.aws.proton.model.primitives.ProvisionedResourceIdentifier(value)
        )
    override val name: Optional[ProvisionedResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.proton.model.primitives.ProvisionedResourceName(value)
      )
    override val provisioningEngine
        : Optional[zio.aws.proton.model.ProvisionedResourceEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningEngine())
        .map(value =>
          zio.aws.proton.model.ProvisionedResourceEngine.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ProvisionedResource
  ): zio.aws.proton.model.ProvisionedResource.ReadOnly = new Wrapper(impl)
}
