package zio.aws.proton.model
import zio.aws.proton.model.primitives.{OutputValueString, OutputKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Output(
    key: Option[OutputKey] = None,
    valueString: Option[OutputValueString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.proton.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Output
      .builder()
      .optionallyWith(
        key.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        valueString.map(value =>
          OutputValueString.unwrap(value): java.lang.String
        )
      )(_.valueString)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Output.ReadOnly =
    zio.aws.proton.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Output] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Output = zio.aws.proton.model
      .Output(key.map(value => value), valueString.map(value => value))
    def key: Option[OutputKey]
    def valueString: Option[OutputValueString]
    def getKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("key", key)
    def getValueString: ZIO[Any, AwsError, OutputValueString] =
      AwsError.unwrapOptionField("valueString", valueString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Output
  ) extends zio.aws.proton.model.Output.ReadOnly {
    override val key: Option[OutputKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.proton.model.primitives.OutputKey(value))
    override val valueString: Option[OutputValueString] = scala
      .Option(impl.valueString())
      .map(value => zio.aws.proton.model.primitives.OutputValueString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Output
  ): zio.aws.proton.model.Output.ReadOnly = new Wrapper(impl)
}
