package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentTemplateResponse(
    environmentTemplate: Option[zio.aws.proton.model.EnvironmentTemplate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse = {
    import DeleteEnvironmentTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse
      .builder()
      .optionallyWith(environmentTemplate.map(value => value.buildAwsValue()))(
        _.environmentTemplate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentTemplateResponse.wrap(buildAwsValue())
}
object DeleteEnvironmentTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteEnvironmentTemplateResponse =
      zio.aws.proton.model.DeleteEnvironmentTemplateResponse(
        environmentTemplate.map(value => value.asEditable)
      )
    def environmentTemplate
        : Option[zio.aws.proton.model.EnvironmentTemplate.ReadOnly]
    def getEnvironmentTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("environmentTemplate", environmentTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse
  ) extends zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly {
    override val environmentTemplate
        : Option[zio.aws.proton.model.EnvironmentTemplate.ReadOnly] = scala
      .Option(impl.environmentTemplate())
      .map(value => zio.aws.proton.model.EnvironmentTemplate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse
  ): zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
