package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  TemplateVersionPart,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateServiceTemplateVersionRequest(
    compatibleEnvironmentTemplates: Option[
      Iterable[zio.aws.proton.model.CompatibleEnvironmentTemplateInput]
    ] = None,
    description: Option[Description] = None,
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    status: Option[zio.aws.proton.model.TemplateVersionStatus] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest = {
    import UpdateServiceTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest
      .builder()
      .optionallyWith(
        compatibleEnvironmentTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleEnvironmentTemplates)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateServiceTemplateVersionRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceTemplateVersionRequest
      .wrap(buildAwsValue())
}
object UpdateServiceTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceTemplateVersionRequest =
      zio.aws.proton.model.UpdateServiceTemplateVersionRequest(
        compatibleEnvironmentTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        majorVersion,
        minorVersion,
        status.map(value => value),
        templateName
      )
    def compatibleEnvironmentTemplates: Option[
      List[zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly]
    ]
    def description: Option[Description]
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def status: Option[zio.aws.proton.model.TemplateVersionStatus]
    def templateName: ResourceName
    def getCompatibleEnvironmentTemplates: ZIO[Any, AwsError, List[
      zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "compatibleEnvironmentTemplates",
      compatibleEnvironmentTemplates
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest
  ) extends zio.aws.proton.model.UpdateServiceTemplateVersionRequest.ReadOnly {
    override val compatibleEnvironmentTemplates: Option[
      List[zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly]
    ] = scala
      .Option(impl.compatibleEnvironmentTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.CompatibleEnvironmentTemplateInput.wrap(item)
        }.toList
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val status: Option[zio.aws.proton.model.TemplateVersionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.proton.model.TemplateVersionStatus.wrap(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest
  ): zio.aws.proton.model.UpdateServiceTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
