package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ServiceArn,
  Timestamp,
  Arn,
  SpecContents,
  Description,
  RepositoryId,
  StatusMessage,
  ResourceName,
  GitBranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Service(
    arn: ServiceArn,
    branchName: Option[GitBranchName] = None,
    createdAt: Timestamp,
    description: Option[Description] = None,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    pipeline: Option[zio.aws.proton.model.ServicePipeline] = None,
    repositoryConnectionArn: Option[Arn] = None,
    repositoryId: Option[RepositoryId] = None,
    spec: SpecContents,
    status: zio.aws.proton.model.ServiceStatus,
    statusMessage: Option[StatusMessage] = None,
    templateName: ResourceName
) {
  def buildAwsValue(): software.amazon.awssdk.services.proton.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Service
      .builder()
      .arn(ServiceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        branchName.map(value => GitBranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(
        repositoryConnectionArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.repositoryConnectionArn)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Service.ReadOnly =
    zio.aws.proton.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Service = zio.aws.proton.model.Service(
      arn,
      branchName.map(value => value),
      createdAt,
      description.map(value => value),
      lastModifiedAt,
      name,
      pipeline.map(value => value.asEditable),
      repositoryConnectionArn.map(value => value),
      repositoryId.map(value => value),
      spec,
      status,
      statusMessage.map(value => value),
      templateName
    )
    def arn: ServiceArn
    def branchName: Option[GitBranchName]
    def createdAt: Timestamp
    def description: Option[Description]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def pipeline: Option[zio.aws.proton.model.ServicePipeline.ReadOnly]
    def repositoryConnectionArn: Option[Arn]
    def repositoryId: Option[RepositoryId]
    def spec: SpecContents
    def status: zio.aws.proton.model.ServiceStatus
    def statusMessage: Option[StatusMessage]
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceArn] = ZIO.succeed(arn)
    def getBranchName: ZIO[Any, AwsError, GitBranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getPipeline
        : ZIO[Any, AwsError, zio.aws.proton.model.ServicePipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
    def getRepositoryConnectionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("repositoryConnectionArn", repositoryConnectionArn)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getStatus: ZIO[Any, Nothing, zio.aws.proton.model.ServiceStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Service
  ) extends zio.aws.proton.model.Service.ReadOnly {
    override val arn: ServiceArn =
      zio.aws.proton.model.primitives.ServiceArn(impl.arn())
    override val branchName: Option[GitBranchName] = scala
      .Option(impl.branchName())
      .map(value => zio.aws.proton.model.primitives.GitBranchName(value))
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val pipeline
        : Option[zio.aws.proton.model.ServicePipeline.ReadOnly] = scala
      .Option(impl.pipeline())
      .map(value => zio.aws.proton.model.ServicePipeline.wrap(value))
    override val repositoryConnectionArn: Option[Arn] = scala
      .Option(impl.repositoryConnectionArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val repositoryId: Option[RepositoryId] = scala
      .Option(impl.repositoryId())
      .map(value => zio.aws.proton.model.primitives.RepositoryId(value))
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val status: zio.aws.proton.model.ServiceStatus =
      zio.aws.proton.model.ServiceStatus.wrap(impl.status())
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Service
  ): zio.aws.proton.model.Service.ReadOnly = new Wrapper(impl)
}
