package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  TemplateVersionPart,
  Arn,
  SpecContents,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentRequest(
    description: Option[Description] = None,
    environmentAccountConnectionId: Option[EnvironmentAccountConnectionId] =
      None,
    name: ResourceName,
    protonServiceRoleArn: Option[Arn] = None,
    provisioningRepository: Option[zio.aws.proton.model.RepositoryBranchInput] =
      None,
    spec: SpecContents,
    tags: Option[Iterable[zio.aws.proton.model.Tag]] = None,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: Option[TemplateVersionPart] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(
        provisioningRepository.map(value => value.buildAwsValue())
      )(_.provisioningRepository)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateEnvironmentRequest =
      zio.aws.proton.model.CreateEnvironmentRequest(
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        name,
        protonServiceRoleArn.map(value => value),
        provisioningRepository.map(value => value.asEditable),
        spec,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateMajorVersion,
        templateMinorVersion.map(value => value),
        templateName
      )
    def description: Option[Description]
    def environmentAccountConnectionId: Option[EnvironmentAccountConnectionId]
    def name: ResourceName
    def protonServiceRoleArn: Option[Arn]
    def provisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def spec: SpecContents
    def tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: Option[TemplateVersionPart]
    def templateName: ResourceName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningRepository",
      provisioningRepository
    )
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ) extends zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Option[EnvironmentAccountConnectionId] = scala
      .Option(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Option[Arn] = scala
      .Option(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] = scala
      .Option(impl.provisioningRepository())
      .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.Tag.wrap(item)
        }.toList
      )
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.templateMinorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ): zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
