package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  TemplateVersionPart,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentTemplateVersionRequest(
    description: Option[Description] = None,
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    status: Option[zio.aws.proton.model.TemplateVersionStatus] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest = {
    import UpdateEnvironmentTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest =
      zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest(
        description.map(value => value),
        majorVersion,
        minorVersion,
        status.map(value => value),
        templateName
      )
    def description: Option[Description]
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def status: Option[zio.aws.proton.model.TemplateVersionStatus]
    def templateName: ResourceName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val status: Option[zio.aws.proton.model.TemplateVersionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.proton.model.TemplateVersionStatus.wrap(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest
  ): zio.aws.proton.model.UpdateEnvironmentTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
