package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    nextToken: Option[String] = None,
    tags: Iterable[zio.aws.proton.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.proton.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListTagsForResourceResponse =
      zio.aws.proton.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[String]
    def tags: List[zio.aws.proton.model.Tag.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, Nothing, List[zio.aws.proton.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse
  ) extends zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val tags: List[zio.aws.proton.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.proton.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse
  ): zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
