package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelServiceInstanceDeploymentRequest(
    serviceInstanceName: ResourceName,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest = {
    import CancelServiceInstanceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest
      .builder()
      .serviceInstanceName(
        ResourceName.unwrap(serviceInstanceName): java.lang.String
      )
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelServiceInstanceDeploymentRequest.ReadOnly =
    zio.aws.proton.model.CancelServiceInstanceDeploymentRequest
      .wrap(buildAwsValue())
}
object CancelServiceInstanceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CancelServiceInstanceDeploymentRequest =
      zio.aws.proton.model.CancelServiceInstanceDeploymentRequest(
        serviceInstanceName,
        serviceName
      )
    def serviceInstanceName: ResourceName
    def serviceName: ResourceName
    def getServiceInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest
  ) extends zio.aws.proton.model.CancelServiceInstanceDeploymentRequest.ReadOnly {
    override val serviceInstanceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceInstanceName())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest
  ): zio.aws.proton.model.CancelServiceInstanceDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
