package zio.aws.proton
import zio.aws.proton.model.GetEnvironmentTemplateResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.proton.model.{
  CreateEnvironmentTemplateVersionRequest,
  GetTemplateSyncConfigRequest,
  DeleteEnvironmentTemplateVersionRequest,
  GetEnvironmentRequest,
  GetEnvironmentAccountConnectionRequest,
  ListServiceInstancesRequest,
  UpdateServicePipelineRequest,
  UpdateAccountSettingsRequest,
  ListEnvironmentsRequest,
  DeleteServiceRequest,
  DeleteEnvironmentTemplateRequest,
  DeleteEnvironmentAccountConnectionRequest,
  CreateServiceTemplateVersionRequest,
  GetServiceTemplateRequest,
  ListEnvironmentOutputsRequest,
  ListServicePipelineProvisionedResourcesRequest,
  ListRepositorySyncDefinitionsRequest,
  GetRepositorySyncStatusRequest,
  UpdateEnvironmentRequest,
  ListEnvironmentProvisionedResourcesRequest,
  CreateEnvironmentTemplateRequest,
  ListTagsForResourceRequest,
  GetTemplateSyncStatusRequest,
  CreateServiceTemplateRequest,
  ListServiceTemplatesRequest,
  NotifyResourceDeploymentStatusChangeRequest,
  UpdateEnvironmentAccountConnectionRequest,
  CreateEnvironmentAccountConnectionRequest,
  CreateRepositoryRequest,
  DeleteServiceTemplateVersionRequest,
  UpdateServiceInstanceRequest,
  DeleteTemplateSyncConfigRequest,
  CreateServiceRequest,
  ListEnvironmentTemplateVersionsRequest,
  RejectEnvironmentAccountConnectionRequest,
  ListServiceInstanceProvisionedResourcesRequest,
  GetEnvironmentTemplateRequest,
  UpdateEnvironmentTemplateVersionRequest,
  ListServiceTemplateVersionsRequest,
  CancelServiceInstanceDeploymentRequest,
  GetEnvironmentTemplateVersionRequest,
  GetServiceTemplateVersionRequest,
  ListServiceInstanceOutputsRequest,
  CreateTemplateSyncConfigRequest,
  DeleteServiceTemplateRequest,
  UpdateEnvironmentTemplateRequest,
  GetServiceRequest,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListEnvironmentAccountConnectionsRequest,
  UpdateServiceTemplateVersionRequest,
  ListEnvironmentTemplatesRequest,
  CancelEnvironmentDeploymentRequest,
  ListServicePipelineOutputsRequest,
  ListServicesRequest,
  UpdateServiceTemplateRequest,
  CreateEnvironmentRequest,
  AcceptEnvironmentAccountConnectionRequest,
  DeleteEnvironmentRequest,
  DeleteRepositoryRequest,
  GetServiceInstanceRequest,
  CancelServicePipelineDeploymentRequest,
  UpdateServiceRequest,
  GetAccountSettingsRequest,
  UpdateTemplateSyncConfigRequest,
  TagResourceRequest,
  GetRepositoryRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.proton.ProtonAsyncClient
object ProtonMock extends Mock[Proton] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object CancelServicePipelineDeployment
      extends Effect[
        CancelServicePipelineDeploymentRequest,
        AwsError,
        zio.aws.proton.model.CancelServicePipelineDeploymentResponse.ReadOnly
      ]
  object UpdateEnvironmentTemplateVersion
      extends Effect[
        UpdateEnvironmentTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly
      ]
  object NotifyResourceDeploymentStatusChange
      extends Effect[
        NotifyResourceDeploymentStatusChangeRequest,
        AwsError,
        zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.ReadOnly
      ]
  object GetRepositorySyncStatus
      extends Effect[
        GetRepositorySyncStatusRequest,
        AwsError,
        zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly
      ]
  object UpdateServiceTemplateVersion
      extends Effect[
        UpdateServiceTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly
      ]
  object GetServiceInstance
      extends Effect[
        GetServiceInstanceRequest,
        AwsError,
        zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.proton.model.CreateServiceResponse.ReadOnly
      ]
  object CreateEnvironmentTemplateVersion
      extends Effect[
        CreateEnvironmentTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.ReadOnly
      ]
  object CreateEnvironmentAccountConnection
      extends Effect[
        CreateEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.ReadOnly
      ]
  object DeleteEnvironmentTemplate
      extends Effect[
        DeleteEnvironmentTemplateRequest,
        AwsError,
        zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly
      ]
  object CreateServiceTemplate
      extends Effect[
        CreateServiceTemplateRequest,
        AwsError,
        zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly
      ]
  object CancelEnvironmentDeployment
      extends Effect[
        CancelEnvironmentDeploymentRequest,
        AwsError,
        zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.proton.model.GetEnvironmentResponse.ReadOnly
      ]
  object DeleteEnvironmentTemplateVersion
      extends Effect[
        DeleteEnvironmentTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly
      ]
  object GetRepository
      extends Effect[
        GetRepositoryRequest,
        AwsError,
        zio.aws.proton.model.GetRepositoryResponse.ReadOnly
      ]
  object ListServiceTemplates
      extends Stream[
        ListServiceTemplatesRequest,
        AwsError,
        zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
      ]
  object ListServiceTemplatesPaginated
      extends Effect[
        ListServiceTemplatesRequest,
        AwsError,
        zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly
      ]
  object ListServiceInstances
      extends Stream[
        ListServiceInstancesRequest,
        AwsError,
        zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
      ]
  object ListServiceInstancesPaginated
      extends Effect[
        ListServiceInstancesRequest,
        AwsError,
        zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly
      ]
  object ListServiceInstanceOutputs
      extends Stream[
        ListServiceInstanceOutputsRequest,
        AwsError,
        zio.aws.proton.model.Output.ReadOnly
      ]
  object ListServiceInstanceOutputsPaginated
      extends Effect[
        ListServiceInstanceOutputsRequest,
        AwsError,
        zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly
      ]
  object DeleteRepository
      extends Effect[
        DeleteRepositoryRequest,
        AwsError,
        zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly
      ]
  object UpdateServicePipeline
      extends Effect[
        UpdateServicePipelineRequest,
        AwsError,
        zio.aws.proton.model.UpdateServicePipelineResponse.ReadOnly
      ]
  object CreateTemplateSyncConfig
      extends Effect[
        CreateTemplateSyncConfigRequest,
        AwsError,
        zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.proton.model.DeleteServiceResponse.ReadOnly
      ]
  object ListServices
      extends Stream[
        ListServicesRequest,
        AwsError,
        zio.aws.proton.model.ServiceSummary.ReadOnly
      ]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.proton.model.ListServicesResponse.ReadOnly
      ]
  object ListEnvironmentAccountConnections
      extends Stream[
        ListEnvironmentAccountConnectionsRequest,
        AwsError,
        zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
      ]
  object ListEnvironmentAccountConnectionsPaginated
      extends Effect[
        ListEnvironmentAccountConnectionsRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly
      ]
  object ListServicePipelineOutputs
      extends Stream[
        ListServicePipelineOutputsRequest,
        AwsError,
        zio.aws.proton.model.Output.ReadOnly
      ]
  object ListServicePipelineOutputsPaginated
      extends Effect[
        ListServicePipelineOutputsRequest,
        AwsError,
        zio.aws.proton.model.ListServicePipelineOutputsResponse.ReadOnly
      ]
  object ListEnvironmentTemplateVersions
      extends Stream[
        ListEnvironmentTemplateVersionsRequest,
        AwsError,
        zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
      ]
  object ListEnvironmentTemplateVersionsPaginated
      extends Effect[
        ListEnvironmentTemplateVersionsRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly
      ]
  object UpdateEnvironmentTemplate
      extends Effect[
        UpdateEnvironmentTemplateRequest,
        AwsError,
        zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly
      ]
  object UpdateEnvironmentAccountConnection
      extends Effect[
        UpdateEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.ReadOnly
      ]
  object UpdateServiceInstance
      extends Effect[
        UpdateServiceInstanceRequest,
        AwsError,
        zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly
      ]
  object DeleteTemplateSyncConfig
      extends Effect[
        DeleteTemplateSyncConfigRequest,
        AwsError,
        zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly
      ]
  object CreateRepository
      extends Effect[
        CreateRepositoryRequest,
        AwsError,
        zio.aws.proton.model.CreateRepositoryResponse.ReadOnly
      ]
  object DeleteServiceTemplate
      extends Effect[
        DeleteServiceTemplateRequest,
        AwsError,
        zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly
      ]
  object ListEnvironments
      extends Stream[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.proton.model.EnvironmentSummary.ReadOnly
      ]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.proton.model.UntagResourceResponse.ReadOnly
      ]
  object CreateServiceTemplateVersion
      extends Effect[
        CreateServiceTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly
      ]
  object ListRepositorySyncDefinitions
      extends Stream[
        ListRepositorySyncDefinitionsRequest,
        AwsError,
        zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
      ]
  object ListRepositorySyncDefinitionsPaginated
      extends Effect[
        ListRepositorySyncDefinitionsRequest,
        AwsError,
        zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly
      ]
  object ListRepositories
      extends Stream[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.proton.model.RepositorySummary.ReadOnly
      ]
  object ListRepositoriesPaginated
      extends Effect[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.proton.model.ListRepositoriesResponse.ReadOnly
      ]
  object GetService
      extends Effect[
        GetServiceRequest,
        AwsError,
        zio.aws.proton.model.GetServiceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.proton.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.proton.model.TagResourceResponse.ReadOnly
      ]
  object UpdateAccountSettings
      extends Effect[
        UpdateAccountSettingsRequest,
        AwsError,
        zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly
      ]
  object RejectEnvironmentAccountConnection
      extends Effect[
        RejectEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.ReadOnly
      ]
  object GetTemplateSyncConfig
      extends Effect[
        GetTemplateSyncConfigRequest,
        AwsError,
        zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object GetServiceTemplate
      extends Effect[
        GetServiceTemplateRequest,
        AwsError,
        zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly
      ]
  object GetTemplateSyncStatus
      extends Effect[
        GetTemplateSyncStatusRequest,
        AwsError,
        zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly
      ]
  object UpdateService
      extends Effect[
        UpdateServiceRequest,
        AwsError,
        zio.aws.proton.model.UpdateServiceResponse.ReadOnly
      ]
  object GetAccountSettings
      extends Effect[
        GetAccountSettingsRequest,
        AwsError,
        zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly
      ]
  object ListServiceTemplateVersions
      extends Stream[
        ListServiceTemplateVersionsRequest,
        AwsError,
        zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
      ]
  object ListServiceTemplateVersionsPaginated
      extends Effect[
        ListServiceTemplateVersionsRequest,
        AwsError,
        zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly
      ]
  object DeleteEnvironmentAccountConnection
      extends Effect[
        DeleteEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly
      ]
  object ListServicePipelineProvisionedResources
      extends Stream[
        ListServicePipelineProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ProvisionedResource.ReadOnly
      ]
  object ListServicePipelineProvisionedResourcesPaginated
      extends Effect[
        ListServicePipelineProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly
      ]
  object DeleteServiceTemplateVersion
      extends Effect[
        DeleteServiceTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly
      ]
  object CreateEnvironmentTemplate
      extends Effect[
        CreateEnvironmentTemplateRequest,
        AwsError,
        zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly
      ]
  object GetEnvironmentTemplateVersion
      extends Effect[
        GetEnvironmentTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.ReadOnly
      ]
  object ListEnvironmentOutputs
      extends Stream[
        ListEnvironmentOutputsRequest,
        AwsError,
        zio.aws.proton.model.Output.ReadOnly
      ]
  object ListEnvironmentOutputsPaginated
      extends Effect[
        ListEnvironmentOutputsRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentOutputsResponse.ReadOnly
      ]
  object GetEnvironmentTemplate
      extends Effect[GetEnvironmentTemplateRequest, AwsError, ReadOnly]
  object UpdateTemplateSyncConfig
      extends Effect[
        UpdateTemplateSyncConfigRequest,
        AwsError,
        zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly
      ]
  object ListEnvironmentTemplates
      extends Stream[
        ListEnvironmentTemplatesRequest,
        AwsError,
        zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
      ]
  object ListEnvironmentTemplatesPaginated
      extends Effect[
        ListEnvironmentTemplatesRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly
      ]
  object UpdateServiceTemplate
      extends Effect[
        UpdateServiceTemplateRequest,
        AwsError,
        zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly
      ]
  object ListEnvironmentProvisionedResources
      extends Stream[
        ListEnvironmentProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ProvisionedResource.ReadOnly
      ]
  object ListEnvironmentProvisionedResourcesPaginated
      extends Effect[
        ListEnvironmentProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.ReadOnly
      ]
  object GetServiceTemplateVersion
      extends Effect[
        GetServiceTemplateVersionRequest,
        AwsError,
        zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly
      ]
  object ListServiceInstanceProvisionedResources
      extends Stream[
        ListServiceInstanceProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ProvisionedResource.ReadOnly
      ]
  object ListServiceInstanceProvisionedResourcesPaginated
      extends Effect[
        ListServiceInstanceProvisionedResourcesRequest,
        AwsError,
        zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly
      ]
  object AcceptEnvironmentAccountConnection
      extends Effect[
        AcceptEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.ReadOnly
      ]
  object CancelServiceInstanceDeployment
      extends Effect[
        CancelServiceInstanceDeploymentRequest,
        AwsError,
        zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly
      ]
  object GetEnvironmentAccountConnection
      extends Effect[
        GetEnvironmentAccountConnectionRequest,
        AwsError,
        zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Proton] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Proton {
          val api: ProtonAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Proton = this
          def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
            AwsError,
            zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly
          ] = proxy(DeleteEnvironment, request)
          def cancelServicePipelineDeployment(
              request: CancelServicePipelineDeploymentRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CancelServicePipelineDeploymentResponse.ReadOnly
          ] = proxy(CancelServicePipelineDeployment, request)
          def updateEnvironmentTemplateVersion(
              request: UpdateEnvironmentTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly
          ] = proxy(UpdateEnvironmentTemplateVersion, request)
          def notifyResourceDeploymentStatusChange(
              request: NotifyResourceDeploymentStatusChangeRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.ReadOnly
          ] = proxy(NotifyResourceDeploymentStatusChange, request)
          def getRepositorySyncStatus(
              request: GetRepositorySyncStatusRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly
          ] = proxy(GetRepositorySyncStatus, request)
          def updateServiceTemplateVersion(
              request: UpdateServiceTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly
          ] = proxy(UpdateServiceTemplateVersion, request)
          def getServiceInstance(request: GetServiceInstanceRequest): IO[
            AwsError,
            zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly
          ] = proxy(GetServiceInstance, request)
          def createService(
              request: CreateServiceRequest
          ): IO[AwsError, zio.aws.proton.model.CreateServiceResponse.ReadOnly] =
            proxy(CreateService, request)
          def createEnvironmentTemplateVersion(
              request: CreateEnvironmentTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.ReadOnly
          ] = proxy(CreateEnvironmentTemplateVersion, request)
          def createEnvironmentAccountConnection(
              request: CreateEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(CreateEnvironmentAccountConnection, request)
          def deleteEnvironmentTemplate(
              request: DeleteEnvironmentTemplateRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly
          ] = proxy(DeleteEnvironmentTemplate, request)
          def createEnvironment(request: CreateEnvironmentRequest): IO[
            AwsError,
            zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly
          ] = proxy(CreateEnvironment, request)
          def createServiceTemplate(request: CreateServiceTemplateRequest): IO[
            AwsError,
            zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly
          ] = proxy(CreateServiceTemplate, request)
          def cancelEnvironmentDeployment(
              request: CancelEnvironmentDeploymentRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly
          ] = proxy(CancelEnvironmentDeployment, request)
          def getEnvironment(request: GetEnvironmentRequest): IO[
            AwsError,
            zio.aws.proton.model.GetEnvironmentResponse.ReadOnly
          ] = proxy(GetEnvironment, request)
          def deleteEnvironmentTemplateVersion(
              request: DeleteEnvironmentTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly
          ] = proxy(DeleteEnvironmentTemplateVersion, request)
          def getRepository(
              request: GetRepositoryRequest
          ): IO[AwsError, zio.aws.proton.model.GetRepositoryResponse.ReadOnly] =
            proxy(GetRepository, request)
          def listServiceTemplates(
              request: ListServiceTemplatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListServiceTemplates, request))
          def listServiceTemplatesPaginated(
              request: ListServiceTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly
          ] = proxy(ListServiceTemplatesPaginated, request)
          def listServiceInstances(
              request: ListServiceInstancesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListServiceInstances, request))
          def listServiceInstancesPaginated(
              request: ListServiceInstancesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly
          ] = proxy(ListServiceInstancesPaginated, request)
          def listServiceInstanceOutputs(
              request: ListServiceInstanceOutputsRequest
          ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly] =
            rts.unsafeRun(proxy(ListServiceInstanceOutputs, request))
          def listServiceInstanceOutputsPaginated(
              request: ListServiceInstanceOutputsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly
          ] = proxy(ListServiceInstanceOutputsPaginated, request)
          def deleteRepository(request: DeleteRepositoryRequest): IO[
            AwsError,
            zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly
          ] = proxy(DeleteRepository, request)
          def updateServicePipeline(request: UpdateServicePipelineRequest): IO[
            AwsError,
            zio.aws.proton.model.UpdateServicePipelineResponse.ReadOnly
          ] = proxy(UpdateServicePipeline, request)
          def createTemplateSyncConfig(
              request: CreateTemplateSyncConfigRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly
          ] = proxy(CreateTemplateSyncConfig, request)
          def deleteService(
              request: DeleteServiceRequest
          ): IO[AwsError, zio.aws.proton.model.DeleteServiceResponse.ReadOnly] =
            proxy(DeleteService, request)
          def listServices(request: ListServicesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ServiceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListServices, request))
          def listServicesPaginated(
              request: ListServicesRequest
          ): IO[AwsError, zio.aws.proton.model.ListServicesResponse.ReadOnly] =
            proxy(ListServicesPaginated, request)
          def listEnvironmentAccountConnections(
              request: ListEnvironmentAccountConnectionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListEnvironmentAccountConnections, request))
          def listEnvironmentAccountConnectionsPaginated(
              request: ListEnvironmentAccountConnectionsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly
          ] = proxy(ListEnvironmentAccountConnectionsPaginated, request)
          def listServicePipelineOutputs(
              request: ListServicePipelineOutputsRequest
          ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly] =
            rts.unsafeRun(proxy(ListServicePipelineOutputs, request))
          def listServicePipelineOutputsPaginated(
              request: ListServicePipelineOutputsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServicePipelineOutputsResponse.ReadOnly
          ] = proxy(ListServicePipelineOutputsPaginated, request)
          def listEnvironmentTemplateVersions(
              request: ListEnvironmentTemplateVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListEnvironmentTemplateVersions, request))
          def listEnvironmentTemplateVersionsPaginated(
              request: ListEnvironmentTemplateVersionsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly
          ] = proxy(ListEnvironmentTemplateVersionsPaginated, request)
          def updateEnvironmentTemplate(
              request: UpdateEnvironmentTemplateRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly
          ] = proxy(UpdateEnvironmentTemplate, request)
          def updateEnvironmentAccountConnection(
              request: UpdateEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(UpdateEnvironmentAccountConnection, request)
          def updateServiceInstance(request: UpdateServiceInstanceRequest): IO[
            AwsError,
            zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly
          ] = proxy(UpdateServiceInstance, request)
          def deleteTemplateSyncConfig(
              request: DeleteTemplateSyncConfigRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly
          ] = proxy(DeleteTemplateSyncConfig, request)
          def createRepository(request: CreateRepositoryRequest): IO[
            AwsError,
            zio.aws.proton.model.CreateRepositoryResponse.ReadOnly
          ] = proxy(CreateRepository, request)
          def deleteServiceTemplate(request: DeleteServiceTemplateRequest): IO[
            AwsError,
            zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly
          ] = proxy(DeleteServiceTemplate, request)
          def listEnvironments(request: ListEnvironmentsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.EnvironmentSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListEnvironments, request))
          def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly
          ] = proxy(ListEnvironmentsPaginated, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.proton.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def createServiceTemplateVersion(
              request: CreateServiceTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly
          ] = proxy(CreateServiceTemplateVersion, request)
          def listRepositorySyncDefinitions(
              request: ListRepositorySyncDefinitionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
          ] = rts.unsafeRun(proxy(ListRepositorySyncDefinitions, request))
          def listRepositorySyncDefinitionsPaginated(
              request: ListRepositorySyncDefinitionsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly
          ] = proxy(ListRepositorySyncDefinitionsPaginated, request)
          def listRepositories(request: ListRepositoriesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.RepositorySummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListRepositories, request))
          def listRepositoriesPaginated(request: ListRepositoriesRequest): IO[
            AwsError,
            zio.aws.proton.model.ListRepositoriesResponse.ReadOnly
          ] = proxy(ListRepositoriesPaginated, request)
          def getService(
              request: GetServiceRequest
          ): IO[AwsError, zio.aws.proton.model.GetServiceResponse.ReadOnly] =
            proxy(GetService, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZStream[Any, AwsError, zio.aws.proton.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTagsForResource, request))
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.proton.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
            AwsError,
            zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly
          ] = proxy(UpdateAccountSettings, request)
          def rejectEnvironmentAccountConnection(
              request: RejectEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(RejectEnvironmentAccountConnection, request)
          def getTemplateSyncConfig(request: GetTemplateSyncConfigRequest): IO[
            AwsError,
            zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly
          ] = proxy(GetTemplateSyncConfig, request)
          def updateEnvironment(request: UpdateEnvironmentRequest): IO[
            AwsError,
            zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly
          ] = proxy(UpdateEnvironment, request)
          def getServiceTemplate(request: GetServiceTemplateRequest): IO[
            AwsError,
            zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly
          ] = proxy(GetServiceTemplate, request)
          def getTemplateSyncStatus(request: GetTemplateSyncStatusRequest): IO[
            AwsError,
            zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly
          ] = proxy(GetTemplateSyncStatus, request)
          def updateService(
              request: UpdateServiceRequest
          ): IO[AwsError, zio.aws.proton.model.UpdateServiceResponse.ReadOnly] =
            proxy(UpdateService, request)
          def getAccountSettings(request: GetAccountSettingsRequest): IO[
            AwsError,
            zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly
          ] = proxy(GetAccountSettings, request)
          def listServiceTemplateVersions(
              request: ListServiceTemplateVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListServiceTemplateVersions, request))
          def listServiceTemplateVersionsPaginated(
              request: ListServiceTemplateVersionsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly
          ] = proxy(ListServiceTemplateVersionsPaginated, request)
          def deleteEnvironmentAccountConnection(
              request: DeleteEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(DeleteEnvironmentAccountConnection, request)
          def listServicePipelineProvisionedResources(
              request: ListServicePipelineProvisionedResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ProvisionedResource.ReadOnly
          ] = rts.unsafeRun(
            proxy(ListServicePipelineProvisionedResources, request)
          )
          def listServicePipelineProvisionedResourcesPaginated(
              request: ListServicePipelineProvisionedResourcesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly
          ] = proxy(ListServicePipelineProvisionedResourcesPaginated, request)
          def deleteServiceTemplateVersion(
              request: DeleteServiceTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly
          ] = proxy(DeleteServiceTemplateVersion, request)
          def createEnvironmentTemplate(
              request: CreateEnvironmentTemplateRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly
          ] = proxy(CreateEnvironmentTemplate, request)
          def getEnvironmentTemplateVersion(
              request: GetEnvironmentTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.ReadOnly
          ] = proxy(GetEnvironmentTemplateVersion, request)
          def listEnvironmentOutputs(
              request: ListEnvironmentOutputsRequest
          ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly] =
            rts.unsafeRun(proxy(ListEnvironmentOutputs, request))
          def listEnvironmentOutputsPaginated(
              request: ListEnvironmentOutputsRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentOutputsResponse.ReadOnly
          ] = proxy(ListEnvironmentOutputsPaginated, request)
          def getEnvironmentTemplate(
              request: GetEnvironmentTemplateRequest
          ): IO[AwsError, ReadOnly] = proxy(GetEnvironmentTemplate, request)
          def updateTemplateSyncConfig(
              request: UpdateTemplateSyncConfigRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly
          ] = proxy(UpdateTemplateSyncConfig, request)
          def listEnvironmentTemplates(
              request: ListEnvironmentTemplatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListEnvironmentTemplates, request))
          def listEnvironmentTemplatesPaginated(
              request: ListEnvironmentTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly
          ] = proxy(ListEnvironmentTemplatesPaginated, request)
          def updateServiceTemplate(request: UpdateServiceTemplateRequest): IO[
            AwsError,
            zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly
          ] = proxy(UpdateServiceTemplate, request)
          def listEnvironmentProvisionedResources(
              request: ListEnvironmentProvisionedResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ProvisionedResource.ReadOnly
          ] = rts.unsafeRun(proxy(ListEnvironmentProvisionedResources, request))
          def listEnvironmentProvisionedResourcesPaginated(
              request: ListEnvironmentProvisionedResourcesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.ReadOnly
          ] = proxy(ListEnvironmentProvisionedResourcesPaginated, request)
          def getServiceTemplateVersion(
              request: GetServiceTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly
          ] = proxy(GetServiceTemplateVersion, request)
          def listServiceInstanceProvisionedResources(
              request: ListServiceInstanceProvisionedResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.proton.model.ProvisionedResource.ReadOnly
          ] = rts.unsafeRun(
            proxy(ListServiceInstanceProvisionedResources, request)
          )
          def listServiceInstanceProvisionedResourcesPaginated(
              request: ListServiceInstanceProvisionedResourcesRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly
          ] = proxy(ListServiceInstanceProvisionedResourcesPaginated, request)
          def acceptEnvironmentAccountConnection(
              request: AcceptEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(AcceptEnvironmentAccountConnection, request)
          def cancelServiceInstanceDeployment(
              request: CancelServiceInstanceDeploymentRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly
          ] = proxy(CancelServiceInstanceDeployment, request)
          def getEnvironmentAccountConnection(
              request: GetEnvironmentAccountConnectionRequest
          ): IO[
            AwsError,
            zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.ReadOnly
          ] = proxy(GetEnvironmentAccountConnection, request)
        }
      }
    }
    .toLayer
}
