package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  Subdirectory,
  RepositoryName,
  GitBranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TemplateSyncConfig(
    branch: GitBranchName,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    subdirectory: Option[Subdirectory] = None,
    templateName: ResourceName,
    templateType: zio.aws.proton.model.TemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.TemplateSyncConfig = {
    import TemplateSyncConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.TemplateSyncConfig
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .optionallyWith(
        subdirectory.map(value => Subdirectory.unwrap(value): java.lang.String)
      )(_.subdirectory)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.TemplateSyncConfig.ReadOnly =
    zio.aws.proton.model.TemplateSyncConfig.wrap(buildAwsValue())
}
object TemplateSyncConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.TemplateSyncConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.TemplateSyncConfig =
      zio.aws.proton.model.TemplateSyncConfig(
        branch,
        repositoryName,
        repositoryProvider,
        subdirectory.map(value => value),
        templateName,
        templateType
      )
    def branch: GitBranchName
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def subdirectory: Option[Subdirectory]
    def templateName: ResourceName
    def templateType: zio.aws.proton.model.TemplateType
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getSubdirectory: ZIO[Any, AwsError, Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, zio.aws.proton.model.TemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.TemplateSyncConfig
  ) extends zio.aws.proton.model.TemplateSyncConfig.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val subdirectory: Option[Subdirectory] = scala
      .Option(impl.subdirectory())
      .map(value => zio.aws.proton.model.primitives.Subdirectory(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
    override val templateType: zio.aws.proton.model.TemplateType =
      zio.aws.proton.model.TemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.TemplateSyncConfig
  ): zio.aws.proton.model.TemplateSyncConfig.ReadOnly = new Wrapper(impl)
}
