package zio.aws.proton.model
import zio.aws.proton.model.primitives.{Arn, MaxPageResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Option[MaxPageResults] = None,
    nextToken: Option[String] = None,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.proton.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListTagsForResourceRequest =
      zio.aws.proton.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Option[MaxPageResults]
    def nextToken: Option[String]
    def resourceArn: Arn
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ) extends zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Option[MaxPageResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val resourceArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ): zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
