package zio.aws.proton.model
import zio.aws.proton.model.primitives.EmptyNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServicePipelineProvisionedResourcesResponse(
    nextToken: Option[EmptyNextToken] = None,
    provisionedResources: Iterable[zio.aws.proton.model.ProvisionedResource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse = {
    import ListServicePipelineProvisionedResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .provisionedResources(provisionedResources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly =
    zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse
      .wrap(buildAwsValue())
}
object ListServicePipelineProvisionedResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse =
      zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse(
        nextToken.map(value => value),
        provisionedResources.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[EmptyNextToken]
    def provisionedResources
        : List[zio.aws.proton.model.ProvisionedResource.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProvisionedResources: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ]] = ZIO.succeed(provisionedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse
  ) extends zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly {
    override val nextToken: Option[EmptyNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val provisionedResources
        : List[zio.aws.proton.model.ProvisionedResource.ReadOnly] = impl
      .provisionedResources()
      .asScala
      .map { item =>
        zio.aws.proton.model.ProvisionedResource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse
  ): zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
