package zio.aws.proton.model
import zio.aws.proton.model.primitives.EmptyNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServiceInstanceOutputsResponse(
    nextToken: Option[EmptyNextToken] = None,
    outputs: Iterable[zio.aws.proton.model.Output]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse = {
    import ListServiceInstanceOutputsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly =
    zio.aws.proton.model.ListServiceInstanceOutputsResponse
      .wrap(buildAwsValue())
}
object ListServiceInstanceOutputsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstanceOutputsResponse =
      zio.aws.proton.model.ListServiceInstanceOutputsResponse(
        nextToken.map(value => value),
        outputs.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[EmptyNextToken]
    def outputs: List[zio.aws.proton.model.Output.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOutputs
        : ZIO[Any, Nothing, List[zio.aws.proton.model.Output.ReadOnly]] =
      ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse
  ) extends zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly {
    override val nextToken: Option[EmptyNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val outputs: List[zio.aws.proton.model.Output.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.proton.model.Output.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse
  ): zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly =
    new Wrapper(impl)
}
