package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  TemplateVersionPart,
  EnvironmentArn,
  Timestamp,
  Arn,
  Description,
  AwsAccountId,
  StatusMessage,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnvironmentSummary(
    arn: EnvironmentArn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Option[StatusMessage] = None,
    description: Option[Description] = None,
    environmentAccountConnectionId: Option[EnvironmentAccountConnectionId] =
      None,
    environmentAccountId: Option[AwsAccountId] = None,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    name: ResourceName,
    protonServiceRoleArn: Option[Arn] = None,
    provisioning: Option[zio.aws.proton.model.Provisioning] = None,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentSummary = {
    import EnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentSummary
      .builder()
      .arn(EnvironmentArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .optionallyWith(
        environmentAccountId.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountId)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(provisioning.map(value => value.unwrap))(_.provisioning)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.EnvironmentSummary.ReadOnly =
    zio.aws.proton.model.EnvironmentSummary.wrap(buildAwsValue())
}
object EnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentSummary =
      zio.aws.proton.model.EnvironmentSummary(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        environmentAccountId.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        name,
        protonServiceRoleArn.map(value => value),
        provisioning.map(value => value),
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: EnvironmentArn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Option[StatusMessage]
    def description: Option[Description]
    def environmentAccountConnectionId: Option[EnvironmentAccountConnectionId]
    def environmentAccountId: Option[AwsAccountId]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def name: ResourceName
    def protonServiceRoleArn: Option[Arn]
    def provisioning: Option[zio.aws.proton.model.Provisioning]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, EnvironmentArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getEnvironmentAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("environmentAccountId", environmentAccountId)
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioning: ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("provisioning", provisioning)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ) extends zio.aws.proton.model.EnvironmentSummary.ReadOnly {
    override val arn: EnvironmentArn =
      zio.aws.proton.model.primitives.EnvironmentArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Option[StatusMessage] = scala
      .Option(impl.deploymentStatusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Option[EnvironmentAccountConnectionId] = scala
      .Option(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val environmentAccountId: Option[AwsAccountId] = scala
      .Option(impl.environmentAccountId())
      .map(value => zio.aws.proton.model.primitives.AwsAccountId(value))
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Option[Arn] = scala
      .Option(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioning: Option[zio.aws.proton.model.Provisioning] = scala
      .Option(impl.provisioning())
      .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ): zio.aws.proton.model.EnvironmentSummary.ReadOnly = new Wrapper(impl)
}
