package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  Arn,
  DisplayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentTemplateRequest(
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    encryptionKey: Option[Arn] = None,
    name: ResourceName,
    provisioning: Option[zio.aws.proton.model.Provisioning] = None,
    tags: Option[Iterable[zio.aws.proton.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest = {
    import CreateEnvironmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(provisioning.map(value => value.unwrap))(_.provisioning)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateEnvironmentTemplateRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentTemplateRequest.wrap(buildAwsValue())
}
object CreateEnvironmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateEnvironmentTemplateRequest =
      zio.aws.proton.model.CreateEnvironmentTemplateRequest(
        description.map(value => value),
        displayName.map(value => value),
        encryptionKey.map(value => value),
        name,
        provisioning.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def encryptionKey: Option[Arn]
    def name: ResourceName
    def provisioning: Option[zio.aws.proton.model.Provisioning]
    def tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProvisioning: ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("provisioning", provisioning)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest
  ) extends zio.aws.proton.model.CreateEnvironmentTemplateRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val encryptionKey: Option[Arn] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val provisioning: Option[zio.aws.proton.model.Provisioning] = scala
      .Option(impl.provisioning())
      .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest
  ): zio.aws.proton.model.CreateEnvironmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
