package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  Arn,
  AwsAccountId,
  ResourceName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentAccountConnectionRequest(
    clientToken: Option[ClientToken] = None,
    environmentName: ResourceName,
    managementAccountId: AwsAccountId,
    roleArn: Arn,
    tags: Option[Iterable[zio.aws.proton.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest = {
    import CreateEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .managementAccountId(
        AwsAccountId.unwrap(managementAccountId): java.lang.String
      )
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object CreateEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest(
        clientToken.map(value => value),
        environmentName,
        managementAccountId,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Option[ClientToken]
    def environmentName: ResourceName
    def managementAccountId: AwsAccountId
    def roleArn: Arn
    def tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getManagementAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(managementAccountId)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val managementAccountId: AwsAccountId =
      zio.aws.proton.model.primitives.AwsAccountId(impl.managementAccountId())
    override val roleArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.roleArn())
    override val tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
