package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, EmptyNextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServicePipelineProvisionedResourcesRequest(
    nextToken: Option[EmptyNextToken] = None,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest = {
    import ListServicePipelineProvisionedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest.ReadOnly =
    zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest
      .wrap(buildAwsValue())
}
object ListServicePipelineProvisionedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest =
      zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest(
        nextToken.map(value => value),
        serviceName
      )
    def nextToken: Option[EmptyNextToken]
    def serviceName: ResourceName
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest
  ) extends zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest.ReadOnly {
    override val nextToken: Option[EmptyNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest
  ): zio.aws.proton.model.ListServicePipelineProvisionedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
