package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, NextToken, MaxPageResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServiceInstancesRequest(
    maxResults: Option[MaxPageResults] = None,
    nextToken: Option[NextToken] = None,
    serviceName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest = {
    import ListServiceInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly =
    zio.aws.proton.model.ListServiceInstancesRequest.wrap(buildAwsValue())
}
object ListServiceInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstancesRequest =
      zio.aws.proton.model.ListServiceInstancesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceName.map(value => value)
      )
    def maxResults: Option[MaxPageResults]
    def nextToken: Option[NextToken]
    def serviceName: Option[ResourceName]
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ) extends zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly {
    override val maxResults: Option[MaxPageResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val serviceName: Option[ResourceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ): zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
