package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTemplateSyncConfigResponse(
    templateSyncConfig: Option[zio.aws.proton.model.TemplateSyncConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse = {
    import DeleteTemplateSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse
      .builder()
      .optionallyWith(templateSyncConfig.map(value => value.buildAwsValue()))(
        _.templateSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.DeleteTemplateSyncConfigResponse.wrap(buildAwsValue())
}
object DeleteTemplateSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteTemplateSyncConfigResponse =
      zio.aws.proton.model.DeleteTemplateSyncConfigResponse(
        templateSyncConfig.map(value => value.asEditable)
      )
    def templateSyncConfig
        : Option[zio.aws.proton.model.TemplateSyncConfig.ReadOnly]
    def getTemplateSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("templateSyncConfig", templateSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse
  ) extends zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly {
    override val templateSyncConfig
        : Option[zio.aws.proton.model.TemplateSyncConfig.ReadOnly] = scala
      .Option(impl.templateSyncConfig())
      .map(value => zio.aws.proton.model.TemplateSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse
  ): zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
