package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentAccountConnectionResponse(
    environmentAccountConnection: Option[
      zio.aws.proton.model.EnvironmentAccountConnection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse = {
    import DeleteEnvironmentAccountConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse
      .builder()
      .optionallyWith(
        environmentAccountConnection.map(value => value.buildAwsValue())
      )(_.environmentAccountConnection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteEnvironmentAccountConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse =
      zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse(
        environmentAccountConnection.map(value => value.asEditable)
      )
    def environmentAccountConnection
        : Option[zio.aws.proton.model.EnvironmentAccountConnection.ReadOnly]
    def getEnvironmentAccountConnection: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentAccountConnection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentAccountConnection",
      environmentAccountConnection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse
  ) extends zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly {
    override val environmentAccountConnection
        : Option[zio.aws.proton.model.EnvironmentAccountConnection.ReadOnly] =
      scala
        .Option(impl.environmentAccountConnection())
        .map(value =>
          zio.aws.proton.model.EnvironmentAccountConnection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse
  ): zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
