package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, DisplayName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentTemplateRequest(
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest = {
    import UpdateEnvironmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentTemplateRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentTemplateRequest =
      zio.aws.proton.model.UpdateEnvironmentTemplateRequest(
        description.map(value => value),
        displayName.map(value => value),
        name
      )
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def name: ResourceName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ): zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
