package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  TemplateVersionPart,
  Arn,
  SpecContents,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    deploymentType: zio.aws.proton.model.DeploymentUpdateType,
    description: Option[Description] = None,
    environmentAccountConnectionId: Option[EnvironmentAccountConnectionId] =
      None,
    name: ResourceName,
    protonServiceRoleArn: Option[Arn] = None,
    provisioningRepository: Option[zio.aws.proton.model.RepositoryBranchInput] =
      None,
    spec: Option[SpecContents] = None,
    templateMajorVersion: Option[TemplateVersionPart] = None,
    templateMinorVersion: Option[TemplateVersionPart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
      .builder()
      .deploymentType(deploymentType.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(
        provisioningRepository.map(value => value.buildAwsValue())
      )(_.provisioningRepository)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .optionallyWith(
        templateMajorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMajorVersion)
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentRequest =
      zio.aws.proton.model.UpdateEnvironmentRequest(
        deploymentType,
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        name,
        protonServiceRoleArn.map(value => value),
        provisioningRepository.map(value => value.asEditable),
        spec.map(value => value),
        templateMajorVersion.map(value => value),
        templateMinorVersion.map(value => value)
      )
    def deploymentType: zio.aws.proton.model.DeploymentUpdateType
    def description: Option[Description]
    def environmentAccountConnectionId: Option[EnvironmentAccountConnectionId]
    def name: ResourceName
    def protonServiceRoleArn: Option[Arn]
    def provisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def spec: Option[SpecContents]
    def templateMajorVersion: Option[TemplateVersionPart]
    def templateMinorVersion: Option[TemplateVersionPart]
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentUpdateType] =
      ZIO.succeed(deploymentType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningRepository",
      provisioningRepository
    )
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMajorVersion", templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly {
    override val deploymentType: zio.aws.proton.model.DeploymentUpdateType =
      zio.aws.proton.model.DeploymentUpdateType.wrap(impl.deploymentType())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Option[EnvironmentAccountConnectionId] = scala
      .Option(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Option[Arn] = scala
      .Option(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] = scala
      .Option(impl.provisioningRepository())
      .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val spec: Option[SpecContents] = scala
      .Option(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.templateMajorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val templateMinorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.templateMinorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ): zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
