package zio.aws.proton.model
import zio.aws.proton.model.primitives.{NextToken, MaxPageResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentTemplatesRequest(
    maxResults: Option[MaxPageResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest = {
    import ListEnvironmentTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentTemplatesRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentTemplatesRequest.wrap(buildAwsValue())
}
object ListEnvironmentTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListEnvironmentTemplatesRequest =
      zio.aws.proton.model.ListEnvironmentTemplatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxPageResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest
  ) extends zio.aws.proton.model.ListEnvironmentTemplatesRequest.ReadOnly {
    override val maxResults: Option[MaxPageResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest
  ): zio.aws.proton.model.ListEnvironmentTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
