package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EmptyNextToken, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentOutputsRequest(
    environmentName: ResourceName,
    nextToken: Option[EmptyNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest = {
    import ListEnvironmentOutputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest
      .builder()
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListEnvironmentOutputsRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentOutputsRequest.wrap(buildAwsValue())
}
object ListEnvironmentOutputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListEnvironmentOutputsRequest =
      zio.aws.proton.model.ListEnvironmentOutputsRequest(
        environmentName,
        nextToken.map(value => value)
      )
    def environmentName: ResourceName
    def nextToken: Option[EmptyNextToken]
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest
  ) extends zio.aws.proton.model.ListEnvironmentOutputsRequest.ReadOnly {
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val nextToken: Option[EmptyNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest
  ): zio.aws.proton.model.ListEnvironmentOutputsRequest.ReadOnly = new Wrapper(
    impl
  )
}
