package zio.aws.proton.model
import zio.aws.proton.model.primitives.{TemplateVersionPart, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTemplateSyncStatusRequest(
    templateName: ResourceName,
    templateType: zio.aws.proton.model.TemplateType,
    templateVersion: TemplateVersionPart
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest = {
    import GetTemplateSyncStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest
      .builder()
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .templateVersion(
        TemplateVersionPart.unwrap(templateVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetTemplateSyncStatusRequest.ReadOnly =
    zio.aws.proton.model.GetTemplateSyncStatusRequest.wrap(buildAwsValue())
}
object GetTemplateSyncStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetTemplateSyncStatusRequest =
      zio.aws.proton.model.GetTemplateSyncStatusRequest(
        templateName,
        templateType,
        templateVersion
      )
    def templateName: ResourceName
    def templateType: zio.aws.proton.model.TemplateType
    def templateVersion: TemplateVersionPart
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, zio.aws.proton.model.TemplateType] =
      ZIO.succeed(templateType)
    def getTemplateVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest
  ) extends zio.aws.proton.model.GetTemplateSyncStatusRequest.ReadOnly {
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
    override val templateType: zio.aws.proton.model.TemplateType =
      zio.aws.proton.model.TemplateType.wrap(impl.templateType())
    override val templateVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest
  ): zio.aws.proton.model.GetTemplateSyncStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
