package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentUpdateType {
  def unwrap: software.amazon.awssdk.services.proton.model.DeploymentUpdateType
}
object DeploymentUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.DeploymentUpdateType
  ): zio.aws.proton.model.DeploymentUpdateType = value match {
    case software.amazon.awssdk.services.proton.model.DeploymentUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.DeploymentUpdateType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.proton.model.DeploymentUpdateType.CURRENT_VERSION =>
      val r = CURRENT_VERSION
      r
    case software.amazon.awssdk.services.proton.model.DeploymentUpdateType.MINOR_VERSION =>
      val r = MINOR_VERSION
      r
    case software.amazon.awssdk.services.proton.model.DeploymentUpdateType.MAJOR_VERSION =>
      val r = MAJOR_VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.DeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.DeploymentUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.proton.model.DeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.DeploymentUpdateType.NONE
  }
  case object CURRENT_VERSION
      extends zio.aws.proton.model.DeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.DeploymentUpdateType.CURRENT_VERSION
  }
  case object MINOR_VERSION extends zio.aws.proton.model.DeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.DeploymentUpdateType.MINOR_VERSION
  }
  case object MAJOR_VERSION extends zio.aws.proton.model.DeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.DeploymentUpdateType.MAJOR_VERSION
  }
}
