package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteRepositoryResponse(
    repository: Option[zio.aws.proton.model.Repository] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse = {
    import DeleteRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly =
    zio.aws.proton.model.DeleteRepositoryResponse.wrap(buildAwsValue())
}
object DeleteRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteRepositoryResponse =
      zio.aws.proton.model
        .DeleteRepositoryResponse(repository.map(value => value.asEditable))
    def repository: Option[zio.aws.proton.model.Repository.ReadOnly]
    def getRepository
        : ZIO[Any, AwsError, zio.aws.proton.model.Repository.ReadOnly] =
      AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse
  ) extends zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly {
    override val repository: Option[zio.aws.proton.model.Repository.ReadOnly] =
      scala
        .Option(impl.repository())
        .map(value => zio.aws.proton.model.Repository.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse
  ): zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly = new Wrapper(impl)
}
