package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateRepositoryResponse(
    repository: zio.aws.proton.model.Repository
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateRepositoryResponse = {
    import CreateRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateRepositoryResponse
      .builder()
      .repository(repository.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateRepositoryResponse.ReadOnly =
    zio.aws.proton.model.CreateRepositoryResponse.wrap(buildAwsValue())
}
object CreateRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateRepositoryResponse =
      zio.aws.proton.model.CreateRepositoryResponse(repository.asEditable)
    def repository: zio.aws.proton.model.Repository.ReadOnly
    def getRepository
        : ZIO[Any, Nothing, zio.aws.proton.model.Repository.ReadOnly] =
      ZIO.succeed(repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateRepositoryResponse
  ) extends zio.aws.proton.model.CreateRepositoryResponse.ReadOnly {
    override val repository: zio.aws.proton.model.Repository.ReadOnly =
      zio.aws.proton.model.Repository.wrap(impl.repository())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateRepositoryResponse
  ): zio.aws.proton.model.CreateRepositoryResponse.ReadOnly = new Wrapper(impl)
}
