package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  TemplateVersionPart,
  Description,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentTemplateVersionRequest(
    clientToken: Option[ClientToken] = None,
    description: Option[Description] = None,
    majorVersion: Option[TemplateVersionPart] = None,
    source: zio.aws.proton.model.TemplateVersionSourceInput,
    tags: Option[Iterable[zio.aws.proton.model.Tag]] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest = {
    import CreateEnvironmentTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        majorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.majorVersion)
      .source(source.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest
      .wrap(buildAwsValue())
}
object CreateEnvironmentTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest =
      zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest(
        clientToken.map(value => value),
        description.map(value => value),
        majorVersion.map(value => value),
        source.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateName
      )
    def clientToken: Option[ClientToken]
    def description: Option[Description]
    def majorVersion: Option[TemplateVersionPart]
    def source: zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly
    def tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateName: ResourceName
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("majorVersion", majorVersion)
    def getSource: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly
    ] = ZIO.succeed(source)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest
  ) extends zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val majorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.majorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val source
        : zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly =
      zio.aws.proton.model.TemplateVersionSourceInput.wrap(impl.source())
    override val tags: Option[List[zio.aws.proton.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.Tag.wrap(item)
        }.toList
      )
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest
  ): zio.aws.proton.model.CreateEnvironmentTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
