package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  ServiceTemplateVersionArn,
  Description,
  StatusMessage,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServiceTemplateVersionSummary(
    arn: ServiceTemplateVersionArn,
    createdAt: Timestamp,
    description: Option[Description] = None,
    lastModifiedAt: Timestamp,
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    recommendedMinorVersion: Option[TemplateVersionPart] = None,
    status: zio.aws.proton.model.TemplateVersionStatus,
    statusMessage: Option[StatusMessage] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary = {
    import ServiceTemplateVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary
      .builder()
      .arn(ServiceTemplateVersionArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .optionallyWith(
        recommendedMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.recommendedMinorVersion)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly =
    zio.aws.proton.model.ServiceTemplateVersionSummary.wrap(buildAwsValue())
}
object ServiceTemplateVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceTemplateVersionSummary =
      zio.aws.proton.model.ServiceTemplateVersionSummary(
        arn,
        createdAt,
        description.map(value => value),
        lastModifiedAt,
        majorVersion,
        minorVersion,
        recommendedMinorVersion.map(value => value),
        status,
        statusMessage.map(value => value),
        templateName
      )
    def arn: ServiceTemplateVersionArn
    def createdAt: Timestamp
    def description: Option[Description]
    def lastModifiedAt: Timestamp
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def recommendedMinorVersion: Option[TemplateVersionPart]
    def status: zio.aws.proton.model.TemplateVersionStatus
    def statusMessage: Option[StatusMessage]
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceTemplateVersionArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getRecommendedMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField(
        "recommendedMinorVersion",
        recommendedMinorVersion
      )
    def getStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.TemplateVersionStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary
  ) extends zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly {
    override val arn: ServiceTemplateVersionArn =
      zio.aws.proton.model.primitives.ServiceTemplateVersionArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val recommendedMinorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.recommendedMinorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val status: zio.aws.proton.model.TemplateVersionStatus =
      zio.aws.proton.model.TemplateVersionStatus.wrap(impl.status())
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary
  ): zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
