package zio.aws.proton.model
import zio.aws.proton.model.primitives.{NextToken, MaxPageResults, ResourceName}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentAccountConnectionsRequest(
    environmentName: Option[ResourceName] = None,
    maxResults: Option[MaxPageResults] = None,
    nextToken: Option[NextToken] = None,
    requestedBy: zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType,
    statuses: Option[
      Iterable[zio.aws.proton.model.EnvironmentAccountConnectionStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest = {
    import ListEnvironmentAccountConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .requestedBy(requestedBy.unwrap)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentAccountConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest =
      zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest(
        environmentName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        requestedBy,
        statuses.map(value => value)
      )
    def environmentName: Option[ResourceName]
    def maxResults: Option[MaxPageResults]
    def nextToken: Option[NextToken]
    def requestedBy
        : zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
    def statuses
        : Option[List[zio.aws.proton.model.EnvironmentAccountConnectionStatus]]
    def getEnvironmentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRequestedBy: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
    ] = ZIO.succeed(requestedBy)
    def getStatuses: ZIO[Any, AwsError, List[
      zio.aws.proton.model.EnvironmentAccountConnectionStatus
    ]] = AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ) extends zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly {
    override val environmentName: Option[ResourceName] = scala
      .Option(impl.environmentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val maxResults: Option[MaxPageResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val requestedBy
        : zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType =
      zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
        .wrap(impl.requestedBy())
    override val statuses: Option[
      List[zio.aws.proton.model.EnvironmentAccountConnectionStatus]
    ] = scala
      .Option(impl.statuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.EnvironmentAccountConnectionStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ): zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
