package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetServiceResponse(
    service: Option[zio.aws.proton.model.Service] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceResponse = {
    import GetServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceResponse.ReadOnly =
    zio.aws.proton.model.GetServiceResponse.wrap(buildAwsValue())
}
object GetServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceResponse =
      zio.aws.proton.model
        .GetServiceResponse(service.map(value => value.asEditable))
    def service: Option[zio.aws.proton.model.Service.ReadOnly]
    def getService: ZIO[Any, AwsError, zio.aws.proton.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceResponse
  ) extends zio.aws.proton.model.GetServiceResponse.ReadOnly {
    override val service: Option[zio.aws.proton.model.Service.ReadOnly] = scala
      .Option(impl.service())
      .map(value => zio.aws.proton.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceResponse
  ): zio.aws.proton.model.GetServiceResponse.ReadOnly = new Wrapper(impl)
}
