package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait UpdateType {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.UpdateType
}
object UpdateType {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.UpdateType
  ): zio.aws.privatenetworks.model.UpdateType = value match {
    case software.amazon.awssdk.services.privatenetworks.model.UpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.UpdateType.REPLACE =>
      val r = REPLACE
      r
    case software.amazon.awssdk.services.privatenetworks.model.UpdateType.RETURN =>
      val r = RETURN
      r
    case software.amazon.awssdk.services.privatenetworks.model.UpdateType.COMMITMENT =>
      val r = COMMITMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.UpdateType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.UpdateType =
      software.amazon.awssdk.services.privatenetworks.model.UpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object REPLACE extends zio.aws.privatenetworks.model.UpdateType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.UpdateType =
      software.amazon.awssdk.services.privatenetworks.model.UpdateType.REPLACE
  }
  case object RETURN extends zio.aws.privatenetworks.model.UpdateType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.UpdateType =
      software.amazon.awssdk.services.privatenetworks.model.UpdateType.RETURN
  }
  case object COMMITMENT extends zio.aws.privatenetworks.model.UpdateType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.UpdateType =
      software.amazon.awssdk.services.privatenetworks.model.UpdateType.COMMITMENT
  }
}
