package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartNetworkResourceUpdateResponse(
    networkResource: Optional[zio.aws.privatenetworks.model.NetworkResource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse = {
    import StartNetworkResourceUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse
      .builder()
      .optionallyWith(networkResource.map(value => value.buildAwsValue()))(
        _.networkResource
      )
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse.ReadOnly =
    zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse
      .wrap(buildAwsValue())
}
object StartNetworkResourceUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse =
      zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse(
        networkResource.map(value => value.asEditable)
      )
    def networkResource
        : Optional[zio.aws.privatenetworks.model.NetworkResource.ReadOnly]
    def getNetworkResource: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    ] = AwsError.unwrapOptionField("networkResource", networkResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse
  ) extends zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse.ReadOnly {
    override val networkResource
        : Optional[zio.aws.privatenetworks.model.NetworkResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkResource())
        .map(value => zio.aws.privatenetworks.model.NetworkResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse
  ): zio.aws.privatenetworks.model.StartNetworkResourceUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
