package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{
  StartNetworkResourceUpdateRequestReturnReasonString,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartNetworkResourceUpdateRequest(
    commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration
    ] = Optional.Absent,
    networkResourceArn: Arn,
    returnReason: Optional[
      StartNetworkResourceUpdateRequestReturnReasonString
    ] = Optional.Absent,
    shippingAddress: Optional[zio.aws.privatenetworks.model.Address] =
      Optional.Absent,
    updateType: zio.aws.privatenetworks.model.UpdateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest = {
    import StartNetworkResourceUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest
      .builder()
      .optionallyWith(
        commitmentConfiguration.map(value => value.buildAwsValue())
      )(_.commitmentConfiguration)
      .networkResourceArn(Arn.unwrap(networkResourceArn): java.lang.String)
      .optionallyWith(
        returnReason.map(value =>
          StartNetworkResourceUpdateRequestReturnReasonString.unwrap(
            value
          ): java.lang.String
        )
      )(_.returnReason)
      .optionallyWith(shippingAddress.map(value => value.buildAwsValue()))(
        _.shippingAddress
      )
      .updateType(updateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest.ReadOnly =
    zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest
      .wrap(buildAwsValue())
}
object StartNetworkResourceUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest =
      zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest(
        commitmentConfiguration.map(value => value.asEditable),
        networkResourceArn,
        returnReason.map(value => value),
        shippingAddress.map(value => value.asEditable),
        updateType
      )
    def commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ]
    def networkResourceArn: Arn
    def returnReason
        : Optional[StartNetworkResourceUpdateRequestReturnReasonString]
    def shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly]
    def updateType: zio.aws.privatenetworks.model.UpdateType
    def getCommitmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "commitmentConfiguration",
      commitmentConfiguration
    )
    def getNetworkResourceArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkResourceArn)
    def getReturnReason: ZIO[
      Any,
      AwsError,
      StartNetworkResourceUpdateRequestReturnReasonString
    ] = AwsError.unwrapOptionField("returnReason", returnReason)
    def getShippingAddress
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.Address.ReadOnly] =
      AwsError.unwrapOptionField("shippingAddress", shippingAddress)
    def getUpdateType
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.UpdateType] =
      ZIO.succeed(updateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest
  ) extends zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest.ReadOnly {
    override val commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commitmentConfiguration())
      .map(value =>
        zio.aws.privatenetworks.model.CommitmentConfiguration.wrap(value)
      )
    override val networkResourceArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkResourceArn())
    override val returnReason
        : Optional[StartNetworkResourceUpdateRequestReturnReasonString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnReason())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .StartNetworkResourceUpdateRequestReturnReasonString(value)
        )
    override val shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shippingAddress())
        .map(value => zio.aws.privatenetworks.model.Address.wrap(value))
    override val updateType: zio.aws.privatenetworks.model.UpdateType =
      zio.aws.privatenetworks.model.UpdateType.wrap(impl.updateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest
  ): zio.aws.privatenetworks.model.StartNetworkResourceUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
