package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReturnInformation(
    replacementOrderArn: Optional[Arn] = Optional.Absent,
    returnReason: Optional[String] = Optional.Absent,
    shippingAddress: Optional[zio.aws.privatenetworks.model.Address] =
      Optional.Absent,
    shippingLabel: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ReturnInformation = {
    import ReturnInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ReturnInformation
      .builder()
      .optionallyWith(
        replacementOrderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.replacementOrderArn)
      .optionallyWith(returnReason.map(value => value: java.lang.String))(
        _.returnReason
      )
      .optionallyWith(shippingAddress.map(value => value.buildAwsValue()))(
        _.shippingAddress
      )
      .optionallyWith(shippingLabel.map(value => value: java.lang.String))(
        _.shippingLabel
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.ReturnInformation.ReadOnly =
    zio.aws.privatenetworks.model.ReturnInformation.wrap(buildAwsValue())
}
object ReturnInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ReturnInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ReturnInformation =
      zio.aws.privatenetworks.model.ReturnInformation(
        replacementOrderArn.map(value => value),
        returnReason.map(value => value),
        shippingAddress.map(value => value.asEditable),
        shippingLabel.map(value => value)
      )
    def replacementOrderArn: Optional[Arn]
    def returnReason: Optional[String]
    def shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly]
    def shippingLabel: Optional[String]
    def getReplacementOrderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("replacementOrderArn", replacementOrderArn)
    def getReturnReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("returnReason", returnReason)
    def getShippingAddress
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.Address.ReadOnly] =
      AwsError.unwrapOptionField("shippingAddress", shippingAddress)
    def getShippingLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("shippingLabel", shippingLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ReturnInformation
  ) extends zio.aws.privatenetworks.model.ReturnInformation.ReadOnly {
    override val replacementOrderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.replacementOrderArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val returnReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.returnReason())
      .map(value => value: String)
    override val shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shippingAddress())
        .map(value => zio.aws.privatenetworks.model.Address.wrap(value))
    override val shippingLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.shippingLabel())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ReturnInformation
  ): zio.aws.privatenetworks.model.ReturnInformation.ReadOnly = new Wrapper(
    impl
  )
}
