package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PingResponse(status: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.PingResponse = {
    import PingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.PingResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.PingResponse.ReadOnly =
    zio.aws.privatenetworks.model.PingResponse.wrap(buildAwsValue())
}
object PingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.PingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.PingResponse =
      zio.aws.privatenetworks.model.PingResponse(status.map(value => value))
    def status: Optional[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.PingResponse
  ) extends zio.aws.privatenetworks.model.PingResponse.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.PingResponse
  ): zio.aws.privatenetworks.model.PingResponse.ReadOnly = new Wrapper(impl)
}
