package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.OrderedResourceDefinitionCountInteger
import scala.jdk.CollectionConverters.*
final case class OrderedResourceDefinition(
    commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration
    ] = Optional.Absent,
    count: OrderedResourceDefinitionCountInteger,
    `type`: zio.aws.privatenetworks.model.NetworkResourceDefinitionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition = {
    import OrderedResourceDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition
      .builder()
      .optionallyWith(
        commitmentConfiguration.map(value => value.buildAwsValue())
      )(_.commitmentConfiguration)
      .count(OrderedResourceDefinitionCountInteger.unwrap(count): Integer)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly =
    zio.aws.privatenetworks.model.OrderedResourceDefinition
      .wrap(buildAwsValue())
}
object OrderedResourceDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.OrderedResourceDefinition =
      zio.aws.privatenetworks.model.OrderedResourceDefinition(
        commitmentConfiguration.map(value => value.asEditable),
        count,
        `type`
      )
    def commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ]
    def count: OrderedResourceDefinitionCountInteger
    def `type`: zio.aws.privatenetworks.model.NetworkResourceDefinitionType
    def getCommitmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "commitmentConfiguration",
      commitmentConfiguration
    )
    def getCount: ZIO[Any, Nothing, OrderedResourceDefinitionCountInteger] =
      ZIO.succeed(count)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.NetworkResourceDefinitionType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition
  ) extends zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly {
    override val commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commitmentConfiguration())
      .map(value =>
        zio.aws.privatenetworks.model.CommitmentConfiguration.wrap(value)
      )
    override val count: OrderedResourceDefinitionCountInteger =
      zio.aws.privatenetworks.model.primitives
        .OrderedResourceDefinitionCountInteger(impl.count())
    override val `type`
        : zio.aws.privatenetworks.model.NetworkResourceDefinitionType =
      zio.aws.privatenetworks.model.NetworkResourceDefinitionType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition
  ): zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly =
    new Wrapper(impl)
}
