package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.{Arn, Timestamp}
import scala.jdk.CollectionConverters.*
final case class Order(
    acknowledgmentStatus: Optional[
      zio.aws.privatenetworks.model.AcknowledgmentStatus
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    networkArn: Optional[Arn] = Optional.Absent,
    networkSiteArn: Optional[Arn] = Optional.Absent,
    orderArn: Optional[Arn] = Optional.Absent,
    orderedResources: Optional[
      Iterable[zio.aws.privatenetworks.model.OrderedResourceDefinition]
    ] = Optional.Absent,
    shippingAddress: Optional[zio.aws.privatenetworks.model.Address] =
      Optional.Absent,
    trackingInformation: Optional[
      Iterable[zio.aws.privatenetworks.model.TrackingInformation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.Order = {
    import Order.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.Order
      .builder()
      .optionallyWith(acknowledgmentStatus.map(value => value.unwrap))(
        _.acknowledgmentStatus
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        networkArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkArn)
      .optionallyWith(
        networkSiteArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkSiteArn)
      .optionallyWith(
        orderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.orderArn)
      .optionallyWith(
        orderedResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderedResources)
      .optionallyWith(shippingAddress.map(value => value.buildAwsValue()))(
        _.shippingAddress
      )
      .optionallyWith(
        trackingInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trackingInformation)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.Order.ReadOnly =
    zio.aws.privatenetworks.model.Order.wrap(buildAwsValue())
}
object Order {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.Order
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.Order =
      zio.aws.privatenetworks.model.Order(
        acknowledgmentStatus.map(value => value),
        createdAt.map(value => value),
        networkArn.map(value => value),
        networkSiteArn.map(value => value),
        orderArn.map(value => value),
        orderedResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        shippingAddress.map(value => value.asEditable),
        trackingInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acknowledgmentStatus
        : Optional[zio.aws.privatenetworks.model.AcknowledgmentStatus]
    def createdAt: Optional[Timestamp]
    def networkArn: Optional[Arn]
    def networkSiteArn: Optional[Arn]
    def orderArn: Optional[Arn]
    def orderedResources: Optional[
      List[zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly]
    ]
    def shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly]
    def trackingInformation: Optional[
      List[zio.aws.privatenetworks.model.TrackingInformation.ReadOnly]
    ]
    def getAcknowledgmentStatus: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.AcknowledgmentStatus
    ] = AwsError.unwrapOptionField("acknowledgmentStatus", acknowledgmentStatus)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getNetworkArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkArn", networkArn)
    def getNetworkSiteArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkSiteArn", networkSiteArn)
    def getOrderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("orderArn", orderArn)
    def getOrderedResources: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("orderedResources", orderedResources)
    def getShippingAddress
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.Address.ReadOnly] =
      AwsError.unwrapOptionField("shippingAddress", shippingAddress)
    def getTrackingInformation: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.TrackingInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("trackingInformation", trackingInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.Order
  ) extends zio.aws.privatenetworks.model.Order.ReadOnly {
    override val acknowledgmentStatus
        : Optional[zio.aws.privatenetworks.model.AcknowledgmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acknowledgmentStatus())
        .map(value =>
          zio.aws.privatenetworks.model.AcknowledgmentStatus.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val networkArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val networkSiteArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkSiteArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val orderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.orderArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val orderedResources: Optional[
      List[zio.aws.privatenetworks.model.OrderedResourceDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.orderedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.privatenetworks.model.OrderedResourceDefinition.wrap(item)
        }.toList
      )
    override val shippingAddress
        : Optional[zio.aws.privatenetworks.model.Address.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shippingAddress())
        .map(value => zio.aws.privatenetworks.model.Address.wrap(value))
    override val trackingInformation: Optional[
      List[zio.aws.privatenetworks.model.TrackingInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingInformation())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.privatenetworks.model.TrackingInformation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.Order
  ): zio.aws.privatenetworks.model.Order.ReadOnly = new Wrapper(impl)
}
