package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkResourceType {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType
}
object NetworkResourceType {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType
  ): zio.aws.privatenetworks.model.NetworkResourceType = value match {
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType.RADIO_UNIT =>
      val r = RADIO_UNIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.NetworkResourceType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object RADIO_UNIT
      extends zio.aws.privatenetworks.model.NetworkResourceType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType.RADIO_UNIT
  }
}
